/*
Given a circular integer array nums of length n, return the maximum possible sum of a non-empty subarray of nums.

Input: nums = [1,-2,3,-2]
Output: 3

https://leetcode.com/problems/maximum-sum-circular-subarray/

*/
class Solution {
     public int maxSubarraySumCircular(int[] A) {
        int total = 0, maxSum = A[0], curMax = 0, minSum = A[0], curMin = 0;
        for (int a : A) {
            curMax = Math.max(curMax + a, a);
            maxSum = Math.max(maxSum, curMax);
            curMin = Math.min(curMin + a, a);
            minSum = Math.min(minSum, curMin);
            total += a;
        }
        return maxSum > 0 ? Math.max(maxSum, total - minSum) : maxSum;
    }
}
